<?php
error_reporting(0);
ini_set('display_errors', 0);
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
include 'db.php';

$apiKey = 'key-Sy2uRMUz9g0sMVsfMSP0VQuwJWJr6NAGisti8yEHRdhnDefTw6d6Lg1cSTkT7HIFa5HS2yAcc2o43rVovO5QUEwugivdOKc';

$bed_id    = (int)($_GET['bed_id'] ?? 1);
$fabric_id = (int)($_GET['fabric_id'] ?? 1);

try {
    $stmt = $pdo->prepare("SELECT * FROM beds WHERE id = ?");
    $stmt->execute([$bed_id]);
    $bed = $stmt->fetch();

    $stmt = $pdo->prepare("SELECT * FROM fabrics WHERE id = ?");
    $stmt->execute([$fabric_id]);
    $fabric = $stmt->fetch();

    if (!$bed || !$fabric) exit;

    // دالة للبحث عن الملف في المسارات المختلفة (لضمان عمل الصور القديمة والجديدة)
    function getFilePath($path) {
        if (file_exists($path)) return realpath($path);
        $check = __DIR__ . '/' . ltrim($path, '/');
        return file_exists($check) ? realpath($check) : false;
    }

    $frameFile = getFilePath($bed['frame_path']);
    $maskFile  = getFilePath($bed['mask_path']);
    $tileFile  = getFilePath($fabric['texture_path']);

    if (!$frameFile || !$maskFile || !$tileFile) exit;

    // معالجة Imagick
    $baseFrame = new Imagick($frameFile);
    $mask = new Imagick($maskFile);
    $w = $baseFrame->getImageWidth();
    $h = $baseFrame->getImageHeight();

    $tile = new Imagick($tileFile);
    $tile->setImageVirtualPixelMethod(Imagick::VIRTUALPIXELMETHOD_MIRROR);
    
    $fabricLayer = new Imagick();
    $fabricLayer->newImage($w, $h, new ImagickPixel('none')); 
    $fabricLayer = $fabricLayer->textureImage($tile);
    
    $mask->resizeImage($w, $h, Imagick::FILTER_LANCZOS, 1);
    $fabricLayer->compositeImage($mask, Imagick::COMPOSITE_DSTIN, 0, 0);

    $shadowLayer = clone $baseFrame;
    $shadowLayer->evaluateImage(Imagick::EVALUATE_MULTIPLY, 0.7, Imagick::CHANNEL_ALPHA);
    $fabricLayer->compositeImage($shadowLayer, Imagick::COMPOSITE_MULTIPLY, 0, 0);

    // AI
    $aiInput = clone $fabricLayer;
    $aiInput->resizeImage(768, 768, Imagick::FILTER_LANCZOS, 1, true);
    $aiInput->setImageFormat('png');
    $renderedData = base64_encode($aiInput->getImageBlob());

    $ch = curl_init('https://api.getimg.ai/v1/stable-diffusion/image-to-image');
    $payload = json_encode([
        'model' => 'stable-diffusion-v1-5',
        'prompt' => "Luxury furniture, {$fabric['name']} fabric, studio lighting, realistic shadows, 8k",
        'image' => $renderedData,
        'strength' => 0.28,
        'steps' => 45,
        'output_format' => 'png'
    ]);

    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer '.$apiKey, 'Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $result = json_decode($response, true);
    curl_close($ch);

    if (isset($result['image'])) {
        $aiImage = new Imagick();
        $aiImage->readImageBlob(base64_decode($result['image']));
        $aiImage->resizeImage($w, $h, Imagick::FILTER_LANCZOS, 1);
        
        // --- إزالة السواد ---
        $aiImage->setImageAlphaChannel(Imagick::ALPHACHANNEL_SET);
        $aiImage->compositeImage($mask, Imagick::COMPOSITE_DSTIN, 0, 0);

        header("Content-Type: image/png");
        echo $aiImage->getImageBlob();
    } else {
        header("Content-Type: image/png");
        echo $fabricLayer->getImageBlob();
    }
} catch (Exception $e) {}