<?php
include 'db.php';

$action = $_GET['action'] ?? '';
$type = $_GET['type'] ?? ''; 
$id = (int)($_GET['id'] ?? 0);

// --- 1. عملية الإضافة مع تقسيم المجلدات ---
if ($action == 'add' && $_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    
    // تحديد المجلد الفرعي بناءً على النوع
    $subDir = ($type == 'beds') ? 'beds' : 'fabrics';
    $targetDir = 'uploads/' . $subDir . '/';

    // إنشاء المجلدات بصلاحيات كاملة إذا لم تكن موجودة
    if (!is_dir($targetDir)) {
        mkdir($targetDir, 0777, true);
    }

    if ($type == 'beds') {
        $framePath = $targetDir . time() . '_frame_' . basename($_FILES['frame']['name']);
        $maskPath  = $targetDir . time() . '_mask_' . basename($_FILES['mask']['name']);
        
        if(move_uploaded_file($_FILES['frame']['tmp_name'], $framePath) && 
           move_uploaded_file($_FILES['mask']['tmp_name'], $maskPath)) {
            $stmt = $pdo->prepare("INSERT INTO beds (name, frame_path, mask_path) VALUES (?, ?, ?)");
            $stmt->execute([$name, $framePath, $maskPath]);
        }
    } else {
        $texturePath = $targetDir . time() . '_texture_' . basename($_FILES['texture']['name']);
        
        if(move_uploaded_file($_FILES['texture']['tmp_name'], $texturePath)) {
            $stmt = $pdo->prepare("INSERT INTO fabrics (name, texture_path) VALUES (?, ?)");
            $stmt->execute([$name, $texturePath]);
        }
    }
    header("Location: admin.php?msg=added");
    exit;
}

// --- 2. عملية الحذف (تحذف السجل والملفات من السيرفر) ---
if ($action == 'delete' && $id > 0) {
    $table = ($type == 'beds') ? 'beds' : 'fabrics';
    $stmt = $pdo->prepare("SELECT * FROM $table WHERE id = ?");
    $stmt->execute([$id]);
    $item = $stmt->fetch();

    if ($item) {
        if ($type == 'beds') {
            @unlink($item['frame_path']);
            @unlink($item['mask_path']);
        } else {
            @unlink($item['texture_path']);
        }
        $pdo->prepare("DELETE FROM $table WHERE id = ?")->execute([$id]);
    }
    header("Location: admin.php?msg=deleted");
    exit;
}

// --- 3. عملية التعديل السريع للاسم ---
if ($action == 'edit' && $_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = (int)$_POST['id'];
    $name = $_POST['name'];
    $table = ($type == 'beds') ? 'beds' : 'fabrics';
    $pdo->prepare("UPDATE $table SET name = ? WHERE id = ?")->execute([$name, $id]);
    header("Location: admin.php?msg=updated");
    exit;
}