<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة محتوى المصمم | لوحة التحكم</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body { background: #f0f2f5; font-family: 'Cairo', sans-serif; }
        .card { border-radius: 20px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.05); margin-bottom: 30px; }
        .header-gradient { background: linear-gradient(45deg, #0d6efd, #00d4ff); color: white; border-radius: 20px 20px 0 0; padding: 20px; }
        .img-preview { width: 50px; height: 50px; object-fit: cover; border-radius: 10px; border: 1px solid #ddd; }
        .table thead { background: #f8f9fa; }
        .edit-input { border: 1px solid transparent; background: #f8f9fa; transition: 0.3s; }
        .edit-input:focus { border-color: #0d6efd; background: white; outline: none; }
        .save-btn { border: none; background: none; color: #198754; font-size: 1.2rem; cursor: pointer; visibility: hidden; }
        tr:hover .save-btn { visibility: visible; }
    </style>
</head>
<body class="container py-5">

    <div class="d-flex justify-content-between align-items-center mb-5">
        <h2 class="fw-bold m-0 text-primary">⚙️ لوحة تحكم النظام</h2>
        <a href="index.php" class="btn btn-dark rounded-pill px-4">🏠 العودة للمصمم</a>
    </div>

    <?php if(isset($_GET['msg'])): ?>
        <div class="alert alert-success alert-dismissible fade show rounded-4 mb-4 border-0 shadow-sm">
            ✅ تم تنفيذ العملية بنجاح!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-xl-6">
            <div class="card shadow-sm mb-4">
                <div class="header-gradient p-3">
                    <h5 class="m-0 text-white">🛏️ إضافة سرير وموديل جديد</h5>
                </div>
                <div class="card-body">
                    <form action="admin_actions.php?action=add&type=beds" method="POST" enctype="multipart/form-data" class="row g-3">
                        <div class="col-12">
                            <input type="text" name="name" class="form-control" required placeholder="اسم الموديل">
                        </div>
                        <div class="col-md-6">
                            <label class="small fw-bold mb-1">الهيكل (Frame)</label>
                            <input type="file" name="frame" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="small fw-bold mb-1">الماسك (Mask)</label>
                            <input type="file" name="mask" class="form-control" required>
                        </div>
                        <div class="col-12 text-end mt-3">
                            <button type="submit" class="btn btn-primary px-4 rounded-pill">إضافة السرير</button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card border-0">
                <div class="card-body p-0 overflow-hidden rounded-4 shadow-sm bg-white">
                    <table class="table table-hover align-middle m-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4">المعاينة</th>
                                <th>الاسم (اضغط للتعديل)</th>
                                <th class="text-center">إجراء</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $beds = $pdo->query("SELECT * FROM beds ORDER BY id DESC")->fetchAll();
                            foreach ($beds as $bed): ?>
                            <tr>
                                <td class="ps-4"><img src="<?= $bed['frame_path'] ?>" class="img-preview"></td>
                                <td>
                                    <form action="admin_actions.php?action=edit&type=beds" method="POST" class="d-flex align-items-center">
                                        <input type="hidden" name="id" value="<?= $bed['id'] ?>">
                                        <input type="text" name="name" class="form-control form-control-sm edit-input py-1 px-2 rounded" value="<?= $bed['name'] ?>">
                                        <button type="submit" class="save-btn ms-2" title="حفظ الاسم الجديد">💾</button>
                                    </form>
                                </td>
                                <td class="text-center">
                                    <a href="admin_actions.php?action=delete&type=beds&id=<?= $bed['id'] ?>" class="btn btn-sm btn-outline-danger border-0" onclick="return confirm('هل أنت متأكد من حذف هذا السرير؟')">🗑️</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-xl-6">
            <div class="card shadow-sm mb-4">
                <div class="header-gradient p-3" style="background: linear-gradient(45deg, #198754, #20c997);">
                    <h5 class="m-0 text-white">🧵 إضافة عينة قماش جديدة</h5>
                </div>
                <div class="card-body">
                    <form action="admin_actions.php?action=add&type=fabrics" method="POST" enctype="multipart/form-data" class="row g-3">
                        <div class="col-12">
                            <input type="text" name="name" class="form-control" required placeholder="نوع القماش">
                        </div>
                        <div class="col-12">
                            <label class="small fw-bold mb-1">صورة القماش (Texture)</label>
                            <input type="file" name="texture" class="form-control" required>
                        </div>
                        <div class="col-12 text-end mt-3">
                            <button type="submit" class="btn btn-success px-4 rounded-pill">إضافة القماش</button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card border-0">
                <div class="card-body p-0 overflow-hidden rounded-4 shadow-sm bg-white">
                    <table class="table table-hover align-middle m-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4">المعاينة</th>
                                <th>الاسم (اضغط للتعديل)</th>
                                <th class="text-center">إجراء</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $fabrics = $pdo->query("SELECT * FROM fabrics ORDER BY id DESC")->fetchAll();
                            foreach ($fabrics as $fabric): ?>
                            <tr>
                                <td class="ps-4"><img src="<?= $fabric['texture_path'] ?>" class="img-preview"></td>
                                <td>
                                    <form action="admin_actions.php?action=edit&type=fabrics" method="POST" class="d-flex align-items-center">
                                        <input type="hidden" name="id" value="<?= $fabric['id'] ?>">
                                        <input type="text" name="name" class="form-control form-control-sm edit-input py-1 px-2 rounded" value="<?= $fabric['name'] ?>">
                                        <button type="submit" class="save-btn ms-2" title="حفظ الاسم الجديد">💾</button>
                                    </form>
                                </td>
                                <td class="text-center">
                                    <a href="admin_actions.php?action=delete&type=fabrics&id=<?= $fabric['id'] ?>" class="btn btn-sm btn-outline-danger border-0" onclick="return confirm('هل أنت متأكد من حذف هذا القماش؟')">🗑️</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>