<?php
// FILE: view_note_details.php - النسخة النهائية المحسّنة بفصل أشرطة العنوان وزيادة التباعد
require_once __DIR__ . '/init.php';

// 🛑 التعديل هنا: إضافة صلاحية 'admin' للدخول
if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'delivery_agent' && $_SESSION['user']['role'] !== 'super_admin' && $_SESSION['user']['role'] !== 'admin')) {
    header('Location: ' . $config['base_url'] . 'login.php');
    exit;
}

// 🎯 التحقق من وجود رقم السند في الرابط
if (!isset($_GET['note_ref']) || empty($_GET['note_ref'])) {
    // 🛠️ يتم توجيه الأدمن العادي أيضاً إلى manage_delivery_notes.php
    $return_page = (in_array($_SESSION['user']['role'], ['super_admin', 'admin'])) ? 'admin/manage_delivery_notes.php' : 'view_delivery_notes.php';
    header('Location: ' . $return_page);
    exit;
}

// جلب البيانات اللازمة
$note_ref = $_GET['note_ref'];
$current_user_role = $_SESSION['user']['role'];
$current_agent_id = $_SESSION['user']['id'];

// 1. جلب اسم المندوب (Agent Username)
$agent_stmt = $pdo->prepare("
    SELECT
        u.username AS agent_username
    FROM
        products p
    JOIN
        users u ON p.delivery_recorded_by = u.id
    WHERE
        p.delivery_note_ref = ?
    LIMIT 1
");
$agent_stmt->execute([$note_ref]);
$agent_info = $agent_stmt->fetch(PDO::FETCH_ASSOC);

$agent_name_display = $agent_info ? htmlspecialchars($agent_info['agent_username']) : 'غير معروف';

// 2. بناء الاستعلام لجلب المنتجات
$sql = "
    SELECT
        id, barcode, name, delivery_date
    FROM
        products
    WHERE
        delivery_note_ref = ?
";
$params = [$note_ref];

// 🛑 الفلترة: يتم فلترة البيانات للمندوب فقط (delivery_agent)
// الأدمن العادي والسوبر أدمن يرون جميع المنتجات في السند بغض النظر عن المسجل.
if ($current_user_role === 'delivery_agent') {
    $sql .= " AND delivery_recorded_by = ?";
    $params[] = $current_agent_id;
}

$sql .= " ORDER BY delivery_date DESC, id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$products_in_note = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>تفاصيل السند رقم: <?= htmlspecialchars($note_ref) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body { font-family: 'Tajawal', sans-serif; background: #f8f9fa; direction: rtl; }
        .blue-bar {
            background-color: #007bff; /* أزرق */
            color: white;
            padding: 10px 0;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        .red-bar {
            background-color: #dc3545; /* أحمر */
            color: white;
            padding: 10px 5px;
            border-radius: 0 0 10px 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
             margin: 5px auto;
            margin-bottom: 20px;
        }
        .info-card {
            border-left: 10px solid #007bff; /* شريط أزرق على اليسار */
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            background-color: #fff;
        }
        .logo-img {
            max-height: 50px; /* التحكم في حجم الشعار */
        }
        .text-truncate {
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
    </style>
</head>
<body>
    
    <div class="blue-bar">
        <div class="container d-flex justify-content-center">
            <img src="/barcode-system/back care LOGO.svg " alt="شعار الشركة" class="logo-img">
        </div>
    </div>
    
    <div class="red-bar">
        <div class="container">
            <h1 class="h3 mb-0 text-center"><i class="bi bi-receipt-cutoff me-2"></i> تفاصيل سند التسليم</h1>
        </div>
    </div>

    <div class="container mt-4">
        <div class="card p-4 shadow-sm">
            
            <div class="info-card p-3 d-flex justify-content-between align-items-center mb-4">
                
                <div class="text-start">
                    <p class="text-muted mb-1 small">
                        <i class="bi bi-tag-fill me-1 text-primary"></i> رقم السند
                    </p>
                    <h3 class="fw-bold text-success mb-0 fs-5 text-truncate" style="max-width: 150px;">
                        <i class="bi bi-hash me-2"></i><?= htmlspecialchars($note_ref) ?>
                    </h3>
                </div>
                
                <div class="text-end">
                    <p class="text-muted mb-1 small">
                        <i class="bi bi-person-badge-fill me-1 text-primary"></i> مسجل بواسطة
                    </p>
                    <h4 class="fw-bold text-info mb-0 fs-5 text-truncate" style="max-width: 150px;">
                        <i class="bi bi-person-circle me-2"></i><?= $agent_name_display ?>
                    </h4>
                </div>
            </div>
            
            <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-3 mb-4">
                <?php $back_link = (in_array($current_user_role, ['super_admin', 'admin'])) ? 'admin/manage_delivery_notes.php' : 'view_delivery_notes.php'; ?>
                
                <a href="<?= $back_link ?>" class="btn btn-info text-white shadow-sm w-100 w-md-auto">
                    <i class="bi bi-arrow-right me-1"></i> العودة إلى قائمة السندات
                </a>
                
                <span class="badge bg-warning text-dark fs-6 py-2 px-3 text-center w-100 w-md-auto">
                    <i class="bi bi-box me-1"></i> عدد المنتجات في السند: **<?= count($products_in_note) ?>**
                </span>
            </div>
            
            <hr class="mt-0">
            
            <?php if (empty($products_in_note)): ?>
                <div class="alert alert-danger text-center mt-3">
                    عفواً، لا توجد منتجات مرتبطة بهذا السند أو ليس لديك صلاحية لعرضها.
                </div>
            <?php else: ?>
                <div class="table-responsive mt-3">
                    <table class="table table-striped table-hover table-bordered">
                        <thead class="table-dark">
                            <tr>
                                <th>#ID</th>
                                <th>الباركود</th>
                                <th>اسم المنتج</th>
                                <th>تاريخ التسليم</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($products_in_note as $product): ?>
                            <tr>
                                <td><?= $product['id'] ?></td>
                                <td><span class="badge bg-light text-dark border"><?= htmlspecialchars($product['barcode']) ?></span></td>
                                <td><?= htmlspecialchars($product['name']) ?></td>
                                <td><?= htmlspecialchars($product['delivery_date']) ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>