<?php
// FILE: admin_dashboard.php - الكود المصحح
require_once __DIR__ . '/init.php';

// 🛑 التحقق من صلاحية الأدمن أو السوبر أدمن فقط
if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'admin' && $_SESSION['user']['role'] !== 'super_admin')) {
    header('Location: ' . $config['base_url'] . 'login.php');
    exit;
}

$username = htmlspecialchars($_SESSION['user']['username']);
$role = $_SESSION['user']['role'];
$page_title = ($role === 'super_admin') ? 'لوحة التحكم الرئيسية' : 'لوحة تحكم الإدارة';

// 🆕 جلب حالة صلاحية طباعة الباركودات الافتراضية
$can_print_virtual = $_SESSION['user']['can_print_virtual'] ?? 0;

// 🆕 تعريف متغير لتسهيل الشرط: إما أن يكون سوبر أدمن، أو لديه الصلاحية المحددة.
$can_access_virtual_print = ($role === 'super_admin' || $can_print_virtual == 1); 
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?php echo $page_title; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    
    <style>
        /* ... كود الستايل هنا (لم يتم تعديله) ... */
        body { font-family: 'Tajawal', sans-serif; background: #f0f2f5; direction: rtl; }
        .dashboard-header { background-color: #007bff; color: white; padding: 20px 0; margin-bottom: 30px; border-radius: 0 0 15px 15px; }
        .control-card {
            text-align: center;
            padding: 20px;
            transition: transform 0.2s, box-shadow 0.2s;
            height: 100%;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        .control-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 16px rgba(0,0,0,0.2);
        }
        .control-icon {
            font-size: 3rem;
            color: #007bff;
            margin-bottom: 10px;
        }
        .row-cols-md-3 > * {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="dashboard-header text-center">
        <div class="container">
            <h1 class="display-4"><?php echo $page_title; ?></h1>
            <p class="lead">مرحباً بك، **<?php echo $username; ?>** (<?php echo $role; ?>)</p>
        </div>
    </div>

    <div class="container">
        <div class="row row-cols-1 row-cols-md-3 g-4">
            
            <div class="col">
                <a href="admin/edit_product.php" class="text-decoration-none d-block">
                    <div class="card control-card bg-primary text-white" style="background-color: #007bff !important;">
                        <i class="bi bi-plus-circle control-icon" style="color: white !important;"></i>
                        <h5 class="card-title text-white">إضافة منتج جديد</h5>
                    </div>
                </a>
            </div>

            <div class="col">
                <a href="admin/products_list.php" class="text-decoration-none d-block">
                    <div class="card control-card bg-white">
                        <i class="bi bi-list-ul control-icon"></i>
                        <h5 class="card-title text-dark">قائمة المنتجات المسجلة</h5>
                    </div>
                </a>
            </div>
            
            <div class="col">
                <a href="admin/generate_barcode_images.php" class="text-decoration-none d-block">
                    <div class="card control-card bg-white">
                        <i class="bi bi-upc-scan control-icon"></i>
                        <h5 class="card-title text-dark">توليد وطباعة الباركودات المسجلة</h5>
                    </div>
                </a>
            </div>
            
            <?php if ($can_access_virtual_print): ?>
            <div class="col">
                <a href="admin/generate_temporary_barcodes.php" class="text-decoration-none d-block">
                    <div class="card control-card bg-white">
                        <i class="bi bi-file-earmark-bar-graph control-icon"></i>
                        <h5 class="card-title text-dark">طباعة باركود (100K+)</h5>
                    </div>
                </a>
            </div>
            <?php endif; ?>
            
            <div class="col">
                <a href="admin/manage_delivery_notes.php" class="text-decoration-none d-block">
                    <div class="card control-card bg-white">
                        <i class="bi bi-truck control-icon"></i>
                        <h5 class="card-title text-dark">إدارة سندات التسليم</h5>
                    </div>
                </a>
            </div>
            
            <?php if ($role === 'super_admin'): ?>
            <div class="col">
                <a href="admin/manage_users.php" class="text-decoration-none d-block">
                    <div class="card control-card bg-white">
                        <i class="bi bi-people control-icon" style="color:#28a745;"></i>
                        <h5 class="card-title text-dark">إدارة المستخدمين</h5>
                    </div>
                </a>
            </div>
            <?php endif; ?>
            
            <div class="col">
                <a href="admin/export_csv.php" class="text-decoration-none d-block">
                    <div class="card control-card bg-white">
                        <i class="bi bi-file-earmark-spreadsheet control-icon" style="color:#ffc107;"></i>
                        <h5 class="card-title text-dark">تصدير قائمة المنتجات (CSV)</h5>
                    </div>
                </a>
            </div>

            <div class="col">
                <a href="admin/change_password.php" class="text-decoration-none d-block">
                    <div class="card control-card bg-white">
                        <i class="bi bi-key control-icon"></i>
                        <h5 class="card-title text-dark">تغيير كلمة المرور</h5>
                    </div>
                </a>
            </div>

            <div class="col">
                <a href="auth.php?action=logout" class="text-decoration-none d-block">
                    <div class="card control-card bg-white">
                        <i class="bi bi-box-arrow-right control-icon" style="color:#dc3545;"></i>
                        <h5 class="card-title text-dark">تسجيل الخروج</h5>
                    </div>
                </a>
            </div>
        </div>
        </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>