<?php 
require_once __DIR__ . '/../init.php'; 

// 🛑 التحقق من الصلاحيات: يجب أن يكون هناك مستخدم مسجل على الأقل
if (!isset($_SESSION['user'])) {
    header('Location: /barcode-system/admin/login.php');
    exit;
}

// 🛑 تحديد الدور وتطبيق القيد
$user_role = $_SESSION['user']['role'] ?? 'admin'; 
$is_super_admin = ($user_role === 'super_admin');

// 🎯 تعريف السمة (attribute) للقراءة فقط، تُضاف لجميع الحقول إذا لم يكن سوبر أدمن
$read_only_attribute = $is_super_admin ? '' : 'readonly';


$id = $_GET['id'] ?? null; 
if(!$id){ header('Location:/barcode-system/admin/index.php'); exit; } 

// جلب جميع الأعمدة
$stmt=$pdo->prepare('SELECT id, barcode, name, size, production_date, expiry_date, notes, delivery_note_ref, delivery_date FROM products WHERE id=?');
$stmt->execute([$id]); 
$p=$stmt->fetch(); 
if(!$p){ echo 'Not found'; exit; } 

// تحديد قيمة تاريخ الإنتاج الحالية (المحفوظة في قاعدة البيانات)
$current_production_date = $p['production_date'] ?? date('Y-m-d'); 
?>
<!doctype html>
<html lang="ar">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>تعديل المنتج - Backcare</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <?php if (!$is_super_admin): ?>
    <style>
        input[readonly], textarea[readonly] {
            background-color: #e9ecef !important;
            opacity: 1; 
        }
    </style>
    <?php endif; ?>
</head>
<body class="p-3">
    <div class="container">
        
        <div class="d-flex justify-content-end mb-4">
            <a href="/barcode-system/admin_dashboard.php" class="btn btn-primary">
                <i class="bi bi-house-door-fill me-2"></i> العودة للوحة التحكم
            </a>
        </div>
        
        <h4><?= $is_super_admin ? 'تعديل المنتج' : 'عرض المنتج' ?> #<?= $p['id'] ?></h4>
        <form id="editForm">
            <input type="hidden" name="id" value="<?= $p['id'] ?>">
            
            <div class="mb-2">
                <label>باركود</label>
                <input name="barcode" value="<?= htmlspecialchars($p['barcode']) ?>" class="form-control" <?= $read_only_attribute ?>>
            </div>
            <div class="mb-2">
                <label>اسم</label>
                <input name="name" value="<?= htmlspecialchars($p['name']) ?>" class="form-control" <?= $read_only_attribute ?>>
            </div>
            <div class="mb-2">
                <label for="size">الحجم (Size)</label>
                <input type="text" id="size" name="size" class="form-control" value="<?= htmlspecialchars($p['size'] ?? '') ?>" <?= $read_only_attribute ?>>
            </div>
            
            <div class="mb-2">
                <label>تاريخ انتاج</label>
                <input name="production_date" 
                        type="date" 
                        value="<?= $current_production_date ?>" 
                        class="form-control"
                        <?= $read_only_attribute ?>> 
            </div>
            
            <div class="mb-2">
                <label>ملاحظات</label>
                <textarea name="notes" class="form-control" <?= $read_only_attribute ?>><?= htmlspecialchars($p['notes']) ?></textarea>
            </div>

            <hr class="mt-4 mb-4">
            <h5 class="text-primary mb-3">بيانات التسليم</h5>
            
            <div class="mb-2">
                <label for="delivery_note_ref" class="form-label">رقم سند التسليم المرجعي</label>
                <input type="text" 
                        class="form-control" 
                        id="delivery_note_ref" 
                        name="delivery_note_ref" 
                        value="<?= htmlspecialchars($p['delivery_note_ref'] ?? '') ?>"
                        <?= $read_only_attribute ?>>
                <small class="form-text text-muted">اتركه فارغاً إذا لم يسجل بعد.</small>
            </div>

            <div class="mb-2">
                <label for="delivery_date" class="form-label">تاريخ التسليم الفعلي</label>
                <input type="date" 
                        class="form-control" 
                        id="delivery_date" 
                        name="delivery_date" 
                        value="<?= $p['delivery_date'] ?>"
                        <?= $read_only_attribute ?>>
                <small class="form-text text-muted">اتركه فارغاً إذا لم يسجل بعد.</small>
            </div>
            
            <?php if ($is_super_admin): ?>
            <button type="submit" class="btn btn-success mt-3">
                 <i class="bi bi-save me-2"></i> حفظ التعديلات
            </button> 
            <?php else: ?>
            <p class="mt-3 text-danger fw-bold">غير مصرح لك بتعديل بيانات هذا المنتج.</p>
            <?php endif; ?>
            
            <a href="/barcode-system/admin/products_list.php" class="btn btn-secondary mt-3">
                <i class="bi bi-arrow-right me-2"></i> عودة لقائمة المنتجات
            </a>
        </form>
    </div>

    <script>
        document.getElementById('editForm').addEventListener('submit', async e => { 
            e.preventDefault(); 
            
            // 🛑 التحقق من الصلاحية في JavaScript قبل الإرسال 🛑
            const isSuperAdmin = <?= $is_super_admin ? 'true' : 'false' ?>;
            if (!isSuperAdmin) {
                alert("غير مصرح لك بحفظ التعديلات.");
                return; 
            }

            const fd = new FormData(e.target); 
            const data = Object.fromEntries(fd.entries()); 
            
            const res = await fetch('/barcode-system/api/products.php', { 
                method: 'PUT', 
                body: new URLSearchParams(data) 
            }); 
            
            // التعامل مع الرد 403 (Forbidden) من API
            if (res.status === 403) {
                 const j = await res.json(); 
                 alert("فشل التعديل: غير مصرح لك بهذه العملية. " + (j.error || ''));
                 return;
            }

            const j = await res.json(); 
            
            if (j.ok) {
                location.href = '/barcode-system/admin/products_list.php'; 
            } else {
                alert("فشل التعديل: " + JSON.stringify(j)); 
            }
        });
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>