<?php
// FILE: api/delivery.php - نقطة نهاية خاصة بمندوب التسليم لتسجيل السند
require_once __DIR__ . '/../init.php';
header('Content-Type: application/json; charset=utf-8');

$method = $_SERVER['REQUEST_METHOD'];

// 🛑 1. التحقق من الصلاحيات: مسموح لـ delivery_agent فقط
$user_id = $_SESSION['user']['id'] ?? null;
$user_role = $_SESSION['user']['role'] ?? null;

if ($user_role !== 'delivery_agent' || !$user_id) {
    // إرجاع استجابة 403 JSON آمنة بدلاً من التوجيه
    http_response_code(403);
    echo json_encode(['error' => 'غير مصرح لك بالوصول إلى هذه الوظيفة. قد تحتاج لتسجيل الدخول مجدداً.']);
    exit;
}

// نستخدم POST للتعديل المخصص للسندات
if ($method === 'POST') {
    // استقبال البيانات من طلب POST
    $data = json_decode(file_get_contents('php://input'), true) ?: $_POST;
    
    $id = $data['id'] ?? null;
    $delivery_note_ref = trim($data['delivery_note_ref'] ?? '');
    $delivery_date = $data['delivery_date'] ?: null;

    if (!$id || !$delivery_note_ref || !$delivery_date) {
        http_response_code(400);
        echo json_encode(['error' => 'المنتج ورقم السند وتاريخ التسليم مطلوبون.']);
        exit;
    }

    try {
        // 2. التحقق من أن السند لم يسجل مسبقاً لهذا المنتج (لمنع التعديل بعد الحفظ الأول)
        $check_stmt = $pdo->prepare("SELECT delivery_note_ref FROM products WHERE id = ?");
        $check_stmt->execute([$id]);
        $current_ref = $check_stmt->fetchColumn();

        if (!empty($current_ref)) {
            // 🛑 المتطلب الأمني: عدم القدرة على التعديل بعد الحفظ الأول
            http_response_code(409);
            echo json_encode(['error' => 'هذا المنتج مُسجل له سند تسليم مسبقاً ولا يمكن تعديله إلا بواسطة المدير.']);
            exit;
        }

        // 3. تنفيذ التعديل الآمن: تحديث حقول التسليم فقط + تسجيل معرف المندوب
        $stmt = $pdo->prepare("
            UPDATE products SET 
                delivery_note_ref = ?, 
                delivery_date = ?, 
                delivery_recorded_by = ? 
            WHERE id = ?
        ");

        $stmt->execute([
            $delivery_note_ref, 
            $delivery_date, 
            $user_id, // تسجيل معرف المندوب الحالي
            $id
        ]);

        echo json_encode(['ok' => true, 'message' => 'تم تسجيل سند التسليم بنجاح.']);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'خطأ في قاعدة البيانات: ' . $e->getMessage()]);
    }
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);