<?php
// FILE: admin/delivery_management.php - نقطة نهاية خاصة بـ Super Admin لإدارة السندات
require_once __DIR__ . '/../init.php'; // تأكد من أن المسار صحيح لملف init
header('Content-Type: application/json; charset=utf-8');

$method = $_SERVER['REQUEST_METHOD'];

// 🛑 1. التحقق من الصلاحيات: مسموح لـ super_admin فقط
$user_id = $_SESSION['user']['id'] ?? null;
$user_role = $_SESSION['user']['role'] ?? null;

if ($user_role !== 'super_admin' || !$user_id) {
    // إرجاع استجابة 403 JSON آمنة
    http_response_code(403);
    echo json_encode(['error' => 'غير مصرح لك بالوصول. صلاحية Super Admin مطلوبة.']);
    exit;
}

// =========================================================
// 🆕 منطق معالجة طلب الحذف (DELETE)
// =========================================================

if ($method === 'DELETE') {
    // استقبال رقم سند التسليم
    $data = json_decode(file_get_contents("php://input"), true);
    $delivery_note_ref = $data['delivery_note_ref'] ?? null;

    if (!$delivery_note_ref) {
        http_response_code(400);
        echo json_encode(['error' => 'Delivery Note Reference is required.']);
        exit;
    }

    // 2. معالجة الحذف داخل Transaction لضمان سلامة البيانات
    try {
        $pdo->beginTransaction();

        // 2.1. تحديث جدول المنتجات (products): حذف مرجع السند وتاريخ التسليم والمندوب
        // في ملف admin/delivery_management.php، ابحث عن هذا الجزء وقم بتعديله:
// ----------------------------------------------------------------------
$stmt_update_products = $pdo->prepare("
    UPDATE products 
    SET 
        delivery_note_ref = NULL, 
        delivery_date = NULL, 
        delivery_recorded_by = NULL
        -- تم حذف السطر التالي لأنه يسبب الخطأ: updated_at = NOW()
    WHERE delivery_note_ref = :ref
");
// ----------------------------------------------------------------------
        $stmt_update_products->execute([':ref' => $delivery_note_ref]);
        $updated_count = $stmt_update_products->rowCount();
        
        // 2.2. (اختياري): حذف السند من جدول السندات المنفصل (إذا كنت تستخدمه)
        // إذا كان لديك جدول 'delivery_notes' يحتوي على رؤوس السندات:
        /*
        $stmt_delete_note = $pdo->prepare("DELETE FROM delivery_notes WHERE ref = :ref");
        $stmt_delete_note->execute([':ref' => $delivery_note_ref]);
        */

        $pdo->commit();
        
        http_response_code(200);
        echo json_encode([
            'ok' => true,
            'message' => "تم حذف مرجع سند التسليم بنجاح: {$delivery_note_ref}. تم تحديث {$updated_count} منتج.",
            'updated_products' => $updated_count
        ]);

    } catch (Exception $e) {
        $pdo->rollBack();
        http_response_code(500);
        echo json_encode(['error' => 'خطأ في قاعدة البيانات أثناء الحذف: ' . $e->getMessage()]);
    }
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
?>