<?php
require_once __DIR__ . '/../init.php';
header('Content-Type: application/json; charset=utf-8');

$method = $_SERVER['REQUEST_METHOD'];

function cleanBarcode($barcode){
    return preg_replace('/[\x00-\x1F\x7F]+/', '', trim($barcode));
}

if($method === 'POST'){
    $data = json_decode(file_get_contents('php://input'), true) ?: $_POST;

    // 🔍 البحث بالباركود فقط
    if(isset($data['barcode']) && !isset($data['name'])){
        $barcode = cleanBarcode($data['barcode']);
        $stmt = $pdo->prepare("SELECT * FROM products WHERE barcode = ?");
        $stmt->execute([$barcode]);
        $product = $stmt->fetch();
        echo json_encode($product ?: ['error'=>'لا يوجد منتج مرتبط بهذا الباركود']);
        exit;
    }

    // ➕ إضافة منتج جديد
    $barcode = cleanBarcode($data['barcode'] ?? '');
    $name = trim($data['name'] ?? '');
    $size = trim($data['size'] ?? '');
    $production_date = $data['production_date'] ?: null;
    $expiry_date = $data['expiry_date'] ?: null;
    $notes = $data['notes'] ?: null;

    if(!$barcode || !$name){
        http_response_code(400);
        echo json_encode(['error'=>'الباركود واسم المنتج مطلوبان']);
        exit;
    }

    $check = $pdo->prepare("SELECT id FROM products WHERE barcode = ?");
    $check->execute([$barcode]);
    if($check->fetch()){
        http_response_code(409);
        echo json_encode(['error'=>'رمز الباركود مسجل مسبقاً']);
        exit;
    }

    try {
        $stmt = $pdo->prepare("INSERT INTO products (barcode, name, size, production_date, expiry_date, notes, created_by) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$barcode, $name, $size ?: null, $production_date, $expiry_date, $notes, $_SESSION['user']['id'] ?? null]);
        echo json_encode(['ok'=>true, 'id'=>$pdo->lastInsertId()]);
    } catch(Exception $e){
        http_response_code(500);
        echo json_encode(['error'=>'حدث خطأ أثناء الحفظ: '.$e->getMessage()]);
    }
    exit;
}

if($method === 'GET'){
    $q = $_GET['q'] ?? '';
    if($q){
        $stmt = $pdo->prepare("SELECT * FROM products WHERE barcode LIKE ? OR name LIKE ? ORDER BY created_at DESC LIMIT 500");
        $stmt->execute(["%$q%", "%$q%"]);
    } else {
        $stmt = $pdo->query("SELECT * FROM products ORDER BY created_at DESC LIMIT 500");
    }
    echo json_encode($stmt->fetchAll());
    exit;
}

if($method === 'PUT'){
    parse_str(file_get_contents('php://input'), $put);
    $id = $put['id'] ?? null;
    if(!$id){
        http_response_code(400); echo json_encode(['error'=>'id required']); exit;
    }
    try{
        $stmt = $pdo->prepare("UPDATE products SET barcode=?, name=?, production_date=?, expiry_date=?, notes=?, size=? WHERE id=?");
        $stmt->execute([$put['barcode']??null,$put['name']??null,$put['production_date']?:null,$put['expiry_date']?:null,$put['notes']?:null,$put['size']??null,$id]);
        echo json_encode(['ok'=>true]);
    }catch(Exception $e){
        http_response_code(500); echo json_encode(['error'=>$e->getMessage()]);
    }
    exit;
}

if($method === 'DELETE'){
    parse_str(file_get_contents('php://input'), $del);
    $id = $del['id'] ?? null;
    if(!$id){
        http_response_code(400); echo json_encode(['error'=>'id required']); exit;
    }
    try{
        $stmt = $pdo->prepare("DELETE FROM products WHERE id=?");
        $stmt->execute([$id]);
        echo json_encode(['ok'=>true]);
    }catch(Exception $e){
        http_response_code(500); echo json_encode(['error'=>$e->getMessage()]);
    }
    exit;
}

http_response_code(405);
echo json_encode(['error'=>'Method not allowed']);
