<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة تحكم دكتور باك كير</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        /* 1. تعريف الخط المرفوع ديناميكياً بناءً على حقل custom_font في الجدول */
        @font-face {
            font-family: 'AppCustomFont';
            @if(isset($settings) && $settings->custom_font)
                /* استدعاء ملف الخط المرفوع من المسار المادي assets/fonts */
                src: url("{{ asset('assets/fonts/' . $settings->custom_font) }}") format('truetype');
            @else
                /* الخطوط الافتراضية للنظام */
                src: local('Segoe UI'), local('Arial');
            @endif
        }

        :root {
            /* جلب اللون الأساسي للهوية المختار من الإعدادات */
            --primary-color: {{ $settings->primary_color ?? '#0984e3' }};
        }

        /* إصلاح تطبيق الخلفية على أعلى مستوى لضمان شمولية التدرج */
        html, body {
            margin: 0;
            padding: 0;
            min-height: 100vh;
            background-attachment: fixed;
        }

        body { 
            /* تطبيق الخط المرفوع مع دعم الخطوط البديلة */
            font-family: 'AppCustomFont', {!! $settings->font_family ?? "'Segoe UI'" !!}, Tahoma, sans-serif !important;

            /* 2. تطبيق منطق الخلفية المتقدم (صورة، تدرج، أو لون ثابت) */
            @if(isset($settings) && $settings->bg_type == 'image' && $settings->bg_image)
                background-image: url("{{ asset('storage/' . $settings->bg_image) }}") !important;
                background-size: cover;
                background-position: center;
                background-repeat: no-repeat;
                background-attachment: fixed;
            @elseif(isset($settings) && $settings->bg_type == 'gradient')
                /* استخدام bg_color لبداية التدرج و bg_gradient_end لنهايته كما في الجدول */
                background: linear-gradient(135deg, {{ $settings->bg_color ?? '#f4f7f6' }}, {{ $settings->bg_gradient_end ?? '#dfe6e9' }}) fixed !important;
            @else
                /* اللون الثابت الافتراضي */
                background-color: {{ $settings->bg_color ?? '#f4f7f6' }} !important;
            @endif
        }

        /* الشريط الجانبي - تصميم داكن وثابت لضمان التباين */
        .sidebar { 
            height: 100vh; 
            background: #2d3436; 
            color: white; 
            position: fixed; 
            right: 0; 
            top: 0; 
            width: 250px; 
            padding-top: 20px; 
            z-index: 1000; 
            overflow-y: auto;
        }

        .sidebar .nav-link { color: #dfe6e9; padding: 12px 20px; border-radius: 0; transition: 0.3s; border-right: 4px solid transparent; }
        
        /* تطبيق اللون الأساسي على التبويب النشط - مع إلغاء الشفافية تماماً */
        .sidebar .nav-link:hover, .sidebar .nav-link.active { 
            background: var(--primary-color) !important; 
            color: white !important; 
            opacity: 1 !important;
            border-right: 4px solid #fff; 
        }

        /* المحتوى الرئيسي - شفاف للسماح بظهور التدرج الخلفي */
        .main-content { 
            margin-right: 250px; 
            padding: 30px; 
            min-height: 100vh; 
            background: transparent !important; 
        }

        .sidebar-header { border-bottom: 1px solid rgba(255,255,255,0.1); padding-bottom: 15px; margin-bottom: 15px; }
        
        /* البطاقات - تصميم زجاجي مع زيادة العتامة لسهولة القراءة */
        .card { 
            border: none !important; 
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1) !important; 
            border-radius: 1.25rem !important; 
            background: rgba(255, 255, 255, 0.94) !important; /* زيادة العتامة للقراءة */
            backdrop-filter: blur(10px);
            margin-bottom: 20px;
        }

        /* إصلاح الأزرار: منع الشفافية وتوضيح الكتابة البيضاء */
        .btn-primary, button[type="submit"], .btn-save {
            background-color: var(--primary-color) !important;
            color: #ffffff !important;
            opacity: 1 !important;
            font-weight: bold !important;
            border: none !important;
            padding: 12px 35px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15) !important;
        }

        @media (max-width: 991px) { 
            .sidebar { right: -250px; } 
            .main-content { margin-right: 0; } 
        }
    </style>
</head>
<body>
    <div class="sidebar shadow">
        <div class="text-center sidebar-header">
            <img src="{{ asset('assets/images/backcare_logo.png') }}" width="100" class="mb-2">
            <h6 class="text-uppercase small opacity-50">نظام الإدارة الذكي</h6>
        </div>
        
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" href="{{ route('admin.dashboard') }}">
                    <i class="fas fa-chart-pie ms-2"></i> الإحصائيات
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link {{ request()->routeIs('admin.questions.index') ? 'active' : '' }}" href="{{ route('admin.questions.index') }}">
                    <i class="fas fa-list-ul ms-2"></i> قائمة الأسئلة
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ request()->routeIs('admin.questions.create') ? 'active' : '' }}" href="{{ route('admin.questions.create') }}">
                    <i class="fas fa-plus-circle ms-2"></i> إضافة سؤال جديد
                </a>
            </li>

            <hr class="mx-3 opacity-25">

            <li class="nav-item">
                <a class="nav-link {{ request()->routeIs('admin.settings.index') ? 'active' : '' }}" href="{{ route('admin.settings.index') }}">
                    <i class="fas fa-paint-roller ms-2"></i> الهوية البصرية والخطوط
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link {{ request()->routeIs('admin.users.*') ? 'active' : '' }}" href="{{ route('admin.users.index') }}">
                    <i class="fas fa-users-cog ms-2"></i> فريق العمل
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link {{ request()->routeIs('admin.profile') ? 'active' : '' }}" href="{{ route('admin.profile') }}">
                    <i class="fas fa-user-lock ms-2"></i> حسابي والأمان
                </a>
            </li>

            <li class="mt-4 px-3">
                <form action="{{ route('admin.logout') }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-outline-danger w-100 rounded-pill btn-sm py-2">
                        <i class="fas fa-power-off ms-1"></i> تسجيل الخروج
                    </button>
                </form>
            </li>
        </ul>
    </div>

    <div class="main-content">
        @if(session('success'))
            <div class="alert alert-success shadow-sm rounded-4 mb-4">
                <i class="fas fa-check-circle me-2"></i> {{ session('success') }}
            </div>
        @endif

        @yield('content')
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</body>
</html>