@extends('layouts.admin') {{-- افترضنا أنك تملك قالب أساسي --}}

@section('content')
<div class="card shadow border-0 p-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold text-primary"><i class="fas fa-users-cog me-2"></i> إدارة فريق العمل</h4>
        <a href="{{ route('admin.users.create') }}" class="btn btn-primary rounded-pill px-4">
            <i class="fas fa-plus me-1"></i> إضافة مستخدم جديد
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success border-0 shadow-sm">{{ session('success') }}</div>
    @endif

    <div class="table-responsive">
        <table class="table table-hover align-middle">
            <thead class="bg-light">
                <tr>
                    <th>الاسم</th>
                    <th>البريد الإلكتروني</th>
                    <th>الصلاحية</th>
                    <th>تاريخ الانضمام</th>
                    <th class="text-center">الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($users as $user)
                <tr>
                    <td class="fw-bold">{{ $user->name }}</td>
                    <td>{{ $user->email }}</td>
                    <td>
                        @if($user->role == 'admin')
                            <span class="badge bg-danger rounded-pill">مدير نظام</span>
                        @else
                            <span class="badge bg-info rounded-pill text-dark">محرر محتوى</span>
                        @endif
                    </td>
<td>{{ optional($user->created_at)->format('Y-m-d') ?? 'غير محدد' }}</td>
<td>{{ $user->created_at ? $user->created_at->format('Y-m-d') : 'غير محدد' }}</td>                    <td class="text-center">
                        <form action="{{ route('admin.users.destroy', $user->id) }}" method="POST" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-outline-danger btn-sm rounded-circle shadow-sm" {{ auth()->id() == $user->id ? 'disabled' : '' }}>
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection