@extends('layouts.admin')

@section('content')
<div class="card shadow border-0 p-4 rounded-4">
    <div class="d-flex align-items-center mb-4">
        <div class="bg-primary text-white rounded-circle p-3 ms-3">
            <i class="fas fa-paint-roller fa-lg"></i>
        </div>
        <h4 class="fw-bold mb-0 text-primary">إعدادات الهوية البصرية والربط</h4>
    </div>
    
    <form action="{{ route('admin.settings.update') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="row">
            <div class="col-md-6 mb-4">
                <div class="p-3 border rounded-4 bg-white h-100 shadow-sm">
                    <label class="form-label fw-bold mb-3"><i class="fas fa-video me-2 text-muted"></i>فيديو المقدمة (Intro)</label>
                    <input type="file" name="intro_video" class="form-control mb-2 rounded-3" accept="video/mp4">
                    @if($settings->intro_video_path)
                        <span class="badge bg-soft-success text-success rounded-pill px-3 mb-2"><i class="fas fa-check-circle me-1"></i> تم رفع فيديو</span>
                    @endif
                    <div class="input-group mt-2">
                        <input type="color" name="intro_bg_color" class="form-control form-control-color border-0 w-25 rounded-start-3" value="{{ $settings->intro_bg_color ?? '#ffffff' }}">
                        <input type="text" class="form-control bg-light border-0 small rounded-end-3" value="لون خلفية التحميل" readonly>
                    </div>
                </div>
            </div>

            <div class="col-md-6 mb-4">
                <div class="p-3 border rounded-4 bg-white h-100 shadow-sm">
                    <label class="form-label fw-bold mb-3"><i class="fas fa-font me-2 text-muted"></i>الخط الرئيسي</label>
                    <select name="font_family" class="form-select mb-3 rounded-3 shadow-none">
                        <option value="'Segoe UI', sans-serif" {{ $settings->font_family == "'Segoe UI', sans-serif" ? 'selected' : '' }}>Segoe UI</option>
                        <option value="'Cairo', sans-serif" {{ $settings->font_family == "'Cairo', sans-serif" ? 'selected' : '' }}>Cairo (عربي)</option>
                    </select>
                    <div class="p-2 bg-light rounded-3 border-dashed">
                        <label class="small fw-bold text-primary mb-1">رفع خط جديد (.ttf)</label>
                        <input type="file" name="custom_font" class="form-control form-control-sm border-0 bg-white" accept=".ttf">
                    </div>
                </div>
            </div>

            <div class="col-md-12 mb-4">
                <div class="p-4 border rounded-4 bg-white shadow-sm">
                    <label class="form-label fw-bold border-bottom pb-3 mb-4 w-100">
                        <i class="fas fa-fill-drip me-2 text-muted"></i>تنسيق خلفية النظام (Background)
                    </label>
                    <div class="row align-items-center">
                        <div class="col-md-4 mb-3">
                            <label class="form-label small fw-bold text-secondary">اختر نوع الخلفية</label>
                            <select name="bg_type" id="bg_type_selector" class="form-select rounded-3 shadow-none border-2">
                                <option value="color" {{ $settings->bg_type == 'color' ? 'selected' : '' }}>لون سادة ثابت</option>
                                <option value="gradient" {{ $settings->bg_type == 'gradient' ? 'selected' : '' }}>تدرج لوني (Gradient)</option>
                                <option value="image" {{ $settings->bg_type == 'image' ? 'selected' : '' }}>صورة تصميم مخصصة</option>
                            </select>
                        </div>
                        <div class="col-md-8">
                            <div id="color_options" class="bg_section {{ $settings->bg_type == 'color' ? '' : 'd-none' }}">
                                <input type="color" name="bg_color" class="form-control form-control-color shadow rounded-circle" style="width: 50px; height: 50px;" value="{{ $settings->bg_color ?? '#f5f7fa' }}">
                            </div>
                            <div id="gradient_options" class="bg_section {{ $settings->bg_type == 'gradient' ? '' : 'd-none' }}">
                                <div class="d-flex gap-2">
                                    <input type="color" name="bg_color_grad_start" class="form-control form-control-color" value="{{ $settings->bg_color ?? '#007bff' }}">
                                    <input type="color" name="bg_gradient_end" class="form-control form-control-color" value="{{ $settings->bg_gradient_end ?? '#00d4ff' }}">
                                </div>
                            </div>
                            <div id="image_options" class="bg_section {{ $settings->bg_type == 'image' ? '' : 'd-none' }}">
                                <input type="file" name="bg_image" class="form-control" accept="image/*">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12 mb-4">
                <div class="card border-0 shadow-sm rounded-4 p-4" style="background: rgba(40, 167, 69, 0.05); border: 1px solid rgba(40, 167, 69, 0.2) !important;">
                    <h5 class="fw-bold mb-4 text-success"><i class="fab fa-whatsapp me-2"></i> إعدادات ربط WhatsApp API</h5>
                    
                    <div class="row">
                        <div class="col-md-12 mb-4">
                            <div class="form-check form-switch p-3 border rounded-3 bg-white">
                                <input class="form-check-input ms-0 me-3" type="checkbox" name="wa_enabled" value="1" id="waEnabled" {{ ($settings->wa_enabled ?? false) ? 'checked' : '' }}>
                                <label class="form-check-label fw-bold" for="waEnabled">تفعيل الإرسال التلقائي عبر واتساب عند الإجابة</label>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label small fw-bold">رابط الـ API (API URL)</label>
                            <input type="text" name="wa_api_url" class="form-control" value="{{ $settings->wa_api_url ?? '' }}" placeholder="https://7105.api.greenapi.com">
                        </div>
                        
                        <div class="col-md-3 mb-3">
                            <label class="form-label small fw-bold">معرف النسخة (Instance ID)</label>
                            <input type="text" name="wa_instance_id" class="form-control" value="{{ $settings->wa_instance_id ?? '' }}">
                        </div>

                        <div class="col-md-3 mb-3">
                            <label class="form-label small fw-bold">الرمز (Access Token)</label>
                            <input type="password" name="wa_token" class="form-control" value="{{ $settings->wa_token ?? '' }}">
                        </div>

                        <div class="col-md-12 mb-3">
                            <label class="form-label small fw-bold">قالب الرسالة الذكي (استخدم {answer} و {link})</label>
                            <textarea name="wa_message_template" class="form-control" rows="4">{{ $settings->wa_message_template ?? '' }}</textarea>
                        </div>

                        <div class="col-md-12">
                            <label class="form-label small fw-bold">الرابط المرفق الافتراضي (Link)</label>
                            <input type="url" name="wa_default_link" class="form-control" value="{{ $settings->wa_default_link ?? '' }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-end mt-4">
            <button type="submit" class="btn btn-primary px-5 py-3 rounded-pill fw-bold shadow-lg">
                <i class="fas fa-save me-2"></i> حفظ جميع الإعدادات
            </button>
        </div>
    </form>
</div>

<script>
    document.getElementById('bg_type_selector').addEventListener('change', function() {
        document.querySelectorAll('.bg_section').forEach(section => section.classList.add('d-none'));
        const activeSection = document.getElementById(this.value + '_options');
        if(activeSection) activeSection.classList.remove('d-none');
    });
</script>

<style>
    .bg-soft-success { background-color: rgba(40, 167, 69, 0.1); }
    .border-dashed { border: 2px dashed #dee2e6; }
    .form-control-color::-webkit-color-swatch { border-radius: 50%; border: none; }
</style>
@endsection