<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::table('settings', function (Blueprint $table) {
        $table->string('wa_api_url')->nullable();
        $table->string('wa_instance_id')->nullable();
        $table->string('wa_token')->nullable();
        $table->text('wa_message_template')->nullable();
        $table->string('wa_default_link')->nullable();
        $table->boolean('wa_enabled')->default(false);
    });
}

public function down()
{
    Schema::table('settings', function (Blueprint $table) {
        $table->dropColumn(['wa_api_url', 'wa_instance_id', 'wa_token', 'wa_message_template', 'wa_default_link', 'wa_enabled']);
    });
}
};
