public function up(): void
{
    Schema::table('settings', function (Blueprint $table) {
        // حقول فيديو المقدمة
        if (!Schema::hasColumn('settings', 'intro_video_path')) $table->string('intro_video_path')->nullable();
        if (!Schema::hasColumn('settings', 'intro_bg_color')) $table->string('intro_bg_color')->default('#ffffff');
        
        // حقول الخطوط
        if (!Schema::hasColumn('settings', 'font_family')) $table->string('font_family')->nullable();
        if (!Schema::hasColumn('settings', 'custom_font')) $table->string('custom_font')->nullable();

        // حقول الخلفية المتقدمة
        if (!Schema::hasColumn('settings', 'bg_type')) $table->string('bg_type')->default('color');
        if (!Schema::hasColumn('settings', 'bg_color')) $table->string('bg_color')->nullable();
        if (!Schema::hasColumn('settings', 'bg_gradient_end')) $table->string('bg_gradient_end')->nullable();
        if (!Schema::hasColumn('settings', 'bg_image')) $table->string('bg_image')->nullable();
        
        // اللون الأساسي
        if (!Schema::hasColumn('settings', 'primary_color')) $table->string('primary_color')->default('#007bff');
    });
}