<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\View; // استيراد كلاس View لمشاركة البيانات
use App\Models\Setting; // استيراد موديل الإعدادات

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // إخبار لارافيل بمسار مجلد public الصحيح
        $this->app->bind('path.public', function() {
            return base_path('public');
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // 1. فرض بروتوكول HTTPS في بيئة الإنتاج
        if (config('app.env') === 'production') {
            URL::forceScheme('https');
        }

        // 2. مشاركة متغير الإعدادات مع جميع صفحات الموقع تلقائياً
        // هذا يحل مشكلة الخطأ في لوحة التحكم وفي صفحة welcome
        View::composer(['layouts.admin', 'welcome'], function ($view) {
            $view->with('settings', Setting::first() ?? new Setting());
        });
    }
}