<?php

namespace App\Http\Controllers;

use App\Models\Question;
use App\Models\Lead; 
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http; 
use Illuminate\Support\Facades\Log;

class QuestionController extends Controller
{
    // عرض الصفحة الرئيسية مع جلب الأسئلة والإعدادات
    public function index()
    {
        $settings = Setting::first() ?? new Setting();
        $questions = Question::orderBy('sort_order', 'asc')->get();
        return view('welcome', compact('settings', 'questions'));
    }

    // جلب تفاصيل السؤال والوسائط عبر AJAX
    public function getAnswer($id) 
    {
        $question = Question::with('answer')->find($id);

        if (!$question || !$question->answer) {
            return response()->json([
                'answer' => 'نعتذر، لم يتم العثور على تفاصيل لهذه الاستشارة حالياً.',
                'status' => false
            ], 404);
        }

        // منطق الفيديو (خاص بالسؤال أو افتراضي)
        $doctorVideo = $question->answer->response_video_path 
            ? asset('storage/' . $question->answer->response_video_path) 
            : asset('assets/video/default_doctor.mp4');

        return response()->json([
            'status'  => true,
            'title'   => $question->title,
            'answer'  => $question->answer->content,
            'image'   => $question->answer->image_path ? asset('storage/' . $question->answer->image_path) : null,
            'video'   => $question->answer->video_path ? asset('storage/' . $question->answer->video_path) : null,
            'audio'   => $question->answer->audio_path ? asset('storage/' . $question->answer->audio_path) : null,
            'doctor_video' => $doctorVideo,
        ]);
    }

    /**
     * دالة إرسال الواتساب الفورية من واجهة المستخدم
     * تم تحديثها لتعمل مع Green API وقالب الرسالة الذكي
     */
    public function sendWhatsapp(Request $request)
{
    // 1. استقبال البيانات
    $phone = $request->phone;
    $answerContent = $request->message;
    $questionTitle = $request->question_title;

    // 2. جلب إعدادات Green API المحدثة
    $settings = \App\Models\Setting::first();
    
    if ($settings && $settings->wa_enabled) {
        // تنظيف وتنسيق الرقم (تحويل 05 إلى 966)
        $cleanPhone = preg_replace('/[^0-9]/', '', $phone);
        if (str_starts_with($cleanPhone, '05')) {
            $cleanPhone = '966' . substr($cleanPhone, 1);
        }
        $formattedPhone = $cleanPhone . "@c.us";

        // بناء رابط الإرسال الصحيح بناءً على صورتك
        $url = rtrim($settings->wa_api_url, '/') . "/waInstance{$settings->wa_instance_id}/sendMessage/{$settings->wa_token}";
        
        // تطبيق القالب الذكي (السؤال والجواب)
        $template = $settings->wa_message_template ?: "*السؤال:* {question}\n*الإجابة:* {answer}";
        $message = str_replace(
            ['{question}', '{answer}', '{link}'],
            [$questionTitle, $answerContent, $settings->wa_default_link ?? ''],
            $template
        );

        // 3. التنفيذ الفوري عبر السيرفر
        \Illuminate\Support\Facades\Http::post($url, [
            "chatId" => $formattedPhone,
            "message" => $message
        ]);
    }

    return response()->json(['success' => true]);
}
}